/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.utils;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.NinePatch;
import com.badlogic.gdx.scenes.scene2d.utils.BaseDrawable;

public class NinePatchDrawable
extends BaseDrawable {
    private NinePatch patch;

    public NinePatchDrawable() {
    }

    public NinePatchDrawable(NinePatch patch2) {
        this.setPatch(patch2);
    }

    public NinePatchDrawable(NinePatchDrawable drawable) {
        super(drawable);
        this.setPatch(drawable.patch);
    }

    @Override
    public void draw(Batch batch, float x, float y, float width, float height) {
        this.patch.draw(batch, x, y, width, height);
    }

    public void setPatch(NinePatch patch2) {
        this.patch = patch2;
        this.setMinWidth(patch2.getTotalWidth());
        this.setMinHeight(patch2.getTotalHeight());
        this.setTopHeight(patch2.getPadTop());
        this.setRightWidth(patch2.getPadRight());
        this.setBottomHeight(patch2.getPadBottom());
        this.setLeftWidth(patch2.getPadLeft());
    }

    public NinePatch getPatch() {
        return this.patch;
    }

    public NinePatchDrawable tint(Color tint) {
        NinePatchDrawable drawable = new NinePatchDrawable(this);
        drawable.setPatch(new NinePatch(drawable.getPatch(), tint));
        return drawable;
    }
}

